using inetsoftware.Pdfc;
using System;
using inetsoftware.Pdfc.Config;
using inetsoftware.Pdfc.Presenter;
using System.IO;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A sample to show, how use a PDFC-Config XML-File.
    /// Expects 3 arguments - the first 2 arguments for the paths of the PDF files to be compared and the last one
    /// for the XML config file.
    /// Example profiles can be found in the ressources folder of the samples.
    /// </summary>
    public class UseXMLConfiguration
    {
        static UseXMLConfiguration()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show, how use a PDFC-Config XML-File.
        /// </summary>
        /// <param name="args">Expected 3 arguments, the first 2 arguments for the path of the PDF files 
        /// and the last one for the XML config file.</param>
        public static void Main(string[] args) {
            if (args == null || args.Length != 3)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2> <XML-Configuration-File>");
            }

            using (new PDFComparer()
                            .LoadProfile(args[2])
                            .AddPresenter(new ReportPDFPresenter(false, true, Path.GetDirectoryName(args[0])))
                            .Compare(args[0], args[1]))
            { }
        }
    }
}
